package easik.states;

import java.util.Hashtable;
import java.util.LinkedList;

import javax.swing.BorderFactory;


import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;

import easik.Easik;
import easik.sketch.edge.GuideEdge;

/**
 *	The basic editing state is the lowest state of the state manager. It can not be popped
 *	off. Basic editing allows access to the basic tools of building sketches.
 *
 *	@author Rob Fletcher 2005
 *	@author Kevin Green 2006
 *	@version 2006-07-13 Kevin Green
 */

public class BasicEditingState extends EasikState {
		
	/**
	 * There is nowhere to go from basic editing (state-wise) so when it is pushed
	 * on, it disables Next and Cancel.
	 */
	public void pushedOn() {
		this.setCancelButton(false);
		this.setNextButton(false);		
	}

	/**
	 * Empty method, as this should never be popped off. 
	 */
	public void poppedOff() {		
	}
	
	/**
	 * Used to identify this class.
	 * 
	 * @return String literal "Basic Editing"
	 */
	public String toString() {
		return "Basic Editing";
	}
	
	/**
	 * Update the selection so that the only selectable items will be those within
	 * reach of the existing edges.
	 */
	public void selectionUpdated() {
		Hashtable selectable = new Hashtable();
		Hashtable unselectable = new Hashtable();

		GraphConstants.setSelectable(selectable, true);
		GraphConstants.setSelectable(unselectable, false);
		
		Object[] entireSet = Easik.getInstance().getFrame().getSketch().getRoots();
		
		resetColors();
		
		Object[] newSelection = Easik.getInstance().getFrame().getSketch().getSelectionCells();
		for(int i=0; i<newSelection.length; i++){
			AttributeMap myMap = ((DefaultGraphCell)newSelection[i]).getAttributes();
			GraphConstants.setBorder(myMap, BorderFactory.createLineBorder(Easik.getInstance().getIni().getSTANDARD_SELECTION_COLOR(), 1));
			GraphConstants.setForeground(myMap, Easik.getInstance().getIni().getSTANDARD_SELECTION_COLOR());
			GraphConstants.setLineColor(myMap, Easik.getInstance().getIni().getSTANDARD_SELECTION_COLOR());
			GraphConstants.setLineWidth(myMap, 1);
			((DefaultGraphCell)newSelection[i]).setAttributes(myMap);
		}

		// If it is, then any edge is selectable
		Easik.getInstance().getFrame().getSketch().getGraphLayoutCache()
		.edit(Easik.getInstance().getFrame().getSketch().getRoots(), selectable);
		
		LinkedList<DefaultEdge> unselectables = new LinkedList<DefaultEdge>();
		// This just loops through the entire set, adding the unselectable cells.
		for (int i = 0; i < entireSet.length; i++) {
			// If it is a guide edge... it is unselectable
			if ((entireSet[i] instanceof DefaultEdge) &&
					(Easik.getInstance().getFrame().getSketch().getAdapter()
					.getEdgeFromCell((DefaultEdge) entireSet[i]) instanceof GuideEdge)) {
				unselectables.add((DefaultEdge)entireSet[i]);
			} 
		}
		
		Easik.getInstance().getFrame().getSketch().getGraphLayoutCache()
		.edit(unselectables.toArray(), unselectable);
			
		setNextButton(false);
		setFinishButton(false);
	}
}
